/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.rewards.builtin;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.rewards.Reward;
import net.puffish.skillsmod.api.rewards.RewardContext;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;

public class CommandReward
implements Reward {
    public static final ResourceLocation ID = SkillsMod.createIdentifier("command");
    private final Map<UUID, Integer> counts = new HashMap<UUID, Integer>();
    private final String command;
    private final String unlockCommand;
    private final String lockCommand;

    private CommandReward(String command, String unlockCommand, String lockCommand) {
        this.command = command;
        this.unlockCommand = unlockCommand;
        this.lockCommand = lockCommand;
    }

    public static void register() {
        SkillsAPI.registerRewardWithData(ID, CommandReward::create);
    }

    private static Result<CommandReward, Failure> create(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(CommandReward::create);
    }

    private static Result<CommandReward, Failure> create(JsonObjectWrapper rootObject) {
        String command = rootObject.getString("command").getSuccess().orElse("");
        String unlockCommand = rootObject.getString("unlock_command").getSuccess().orElse("");
        String lockCommand = rootObject.getString("lock_command").getSuccess().orElse("");
        return Result.success(new CommandReward(command, unlockCommand, lockCommand));
    }

    private void executeCommand(ServerPlayer player, String command) {
        if (command.isBlank()) {
            return;
        }
        MinecraftServer server = Objects.requireNonNull(player.m_20194_());
        server.m_129892_().m_230957_(player.m_20203_().m_81324_().m_81325_(server.m_7034_()), command);
    }

    @Override
    public void update(ServerPlayer player, RewardContext context) {
        if (context.recent()) {
            this.executeCommand(player, this.command);
        }
        this.counts.compute(player.m_20148_(), (uuid, count) -> {
            Integer n;
            if (count == null) {
                count = 0;
            }
            while (context.count() > count) {
                this.executeCommand(player, this.unlockCommand);
                n = count;
                count = count + 1;
            }
            while (context.count() < count) {
                this.executeCommand(player, this.lockCommand);
                n = count;
                count = count - 1;
            }
            return count;
        });
    }

    @Override
    public void dispose(MinecraftServer server) {
        for (Map.Entry<UUID, Integer> entry : this.counts.entrySet()) {
            ServerPlayer player = server.m_6846_().m_11259_(entry.getKey());
            if (player == null) continue;
            for (int i = 0; i < entry.getValue(); ++i) {
                this.executeCommand(player, this.lockCommand);
            }
        }
        this.counts.clear();
    }
}

